/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;
import java.util.ArrayList;
import org.jpedal.fonts.objects.FontData;

public class FontFile2
implements Serializable {
    private static final long serialVersionUID = -3097990864237320960L;
    public static final int HEAD = 0;
    public static final int MAXP = 1;
    public static final int CMAP = 2;
    public static final int LOCA = 3;
    public static final int GLYF = 4;
    public static final int HHEA = 5;
    public static final int HMTX = 6;
    public static final int NAME = 7;
    public static final int POST = 8;
    public static final int CVT = 9;
    public static final int FPGM = 10;
    public static final int HDMX = 11;
    public static final int KERN = 12;
    public static final int OS2 = 13;
    public static final int PREP = 14;
    public static final int DSIG = 15;
    public static final int CFF = 16;
    public static final int GSUB = 17;
    public static final int BASE = 18;
    public static final int EBDT = 19;
    public static final int EBLC = 20;
    public static final int GASP = 21;
    public static final int VHEA = 22;
    public static final int VMTX = 23;
    public static final int GDEF = 24;
    public static final int JSTF = 25;
    public static final int LTSH = 26;
    public static final int PCLT = 27;
    public static final int VDMX = 28;
    public static final int BSLN = 29;
    public static final int MORT = 30;
    public static final int FDSC = 31;
    public static final int FFTM = 32;
    public static final int GPOS = 33;
    public static final int FEAT = 34;
    public static final int JUST = 35;
    public static final int PROP = 36;
    public static final int LCCL = 37;
    public static final int Zapf = 38;
    protected int tableCount = 39;
    protected int[][] checksums;
    protected int[][] tables;
    protected int[][] tableLength;
    private FontData fontDataAsObject = null;
    private byte[] fontDataAsArray = null;
    private boolean useArray = true;
    protected ArrayList tableList = new ArrayList(32);
    private int pointer = 0;
    public static final int OPENTYPE = 1;
    public static final int TRUETYPE = 2;
    public static final int TTC = 3;
    public static final int PS = 10;
    public static final int TTF = 11;
    protected int subType = 10;
    protected int type = 2;
    public int currentFontID = 0;
    private int fontCount = 1;
    protected int numTables = 11;
    protected int searchRange = 128;
    protected int entrySelector = 3;
    protected int rangeShift = 48;

    public FontFile2(FontData fontData) {
        this.useArray = false;
        this.fontDataAsObject = fontData;
        this.readHeader();
    }

    public FontFile2(byte[] byArray) {
        this.useArray = true;
        this.fontDataAsArray = byArray;
        this.readHeader();
    }

    public FontFile2(byte[] byArray, boolean bl) {
        this.useArray = true;
        this.fontDataAsArray = byArray;
        if (!bl) {
            this.readHeader();
        }
    }

    public FontFile2() {
    }

    public void setSelectedFontIndex(int n) {
        if (n < this.fontCount) {
            this.currentFontID = n;
        }
    }

    private final void readHeader() {
        int n = this.getNextUint32();
        if (n == 0x4F54544F) {
            this.type = 1;
        } else if (n == 1953784678) {
            this.type = 3;
        }
        if (this.type == 3) {
            int n2;
            this.getNextUint32();
            this.fontCount = this.getNextUint32();
            this.checksums = new int[this.tableCount][this.fontCount];
            this.tables = new int[this.tableCount][this.fontCount];
            this.tableLength = new int[this.tableCount][this.fontCount];
            int[] nArray = new int[this.fontCount];
            for (n2 = 0; n2 < this.fontCount; ++n2) {
                int n3;
                this.currentFontID = n2;
                nArray[n2] = n3 = this.getNextUint32();
            }
            for (n2 = 0; n2 < this.fontCount; ++n2) {
                this.currentFontID = n2;
                this.pointer = nArray[n2];
                this.getNextUint32();
                this.readTablesForFont();
            }
            this.currentFontID = 0;
        } else {
            this.checksums = new int[this.tableCount][1];
            this.tables = new int[this.tableCount][1];
            this.tableLength = new int[this.tableCount][1];
            this.readTablesForFont();
        }
    }

    private void readTablesForFont() {
        this.numTables = this.getNextUint16();
        this.searchRange = this.getNextUint16();
        this.entrySelector = this.getNextUint16();
        this.rangeShift = this.getNextUint16();
        for (int i = 0; i < this.numTables; ++i) {
            String string = this.getNextUint32AsTag();
            int n = this.getNextUint32();
            int n2 = this.getNextUint32();
            int n3 = this.getNextUint32();
            this.tableList.add(string);
            int n4 = FontFile2.getTableID(string);
            if (n4 == -1) continue;
            this.checksums[n4][this.currentFontID] = n;
            this.tables[n4][this.currentFontID] = n2;
            this.tableLength[n4][this.currentFontID] = n3;
        }
    }

    protected static int getTableID(String string) {
        int n = -1;
        if (string.equals("maxp")) {
            n = 1;
        } else if (string.equals("head")) {
            n = 0;
        } else if (string.equals("cmap")) {
            n = 2;
        } else if (string.equals("loca")) {
            n = 3;
        } else if (string.equals("glyf")) {
            n = 4;
        } else if (string.equals("hhea")) {
            n = 5;
        } else if (string.equals("hmtx")) {
            n = 6;
        } else if (string.equals("name")) {
            n = 7;
        } else if (string.equals("post")) {
            n = 8;
        } else if (string.equals("cvt ")) {
            n = 9;
        } else if (string.equals("fpgm")) {
            n = 10;
        } else if (string.equals("hdmx")) {
            n = 11;
        } else if (string.equals("kern")) {
            n = 12;
        } else if (string.equals("OS/2")) {
            n = 13;
        } else if (string.equals("prep")) {
            n = 14;
        } else if (string.equals("DSIG")) {
            n = 15;
        } else if (string.equals("BASE")) {
            n = 18;
        } else if (string.equals("CFF ")) {
            n = 16;
        } else if (string.equals("GSUB")) {
            n = 17;
        } else if (string.equals("EBDT")) {
            n = 19;
        } else if (string.equals("EBLC")) {
            n = 20;
        } else if (string.equals("gasp")) {
            n = 21;
        } else if (string.equals("vhea")) {
            n = 22;
        } else if (string.equals("vmtx")) {
            n = 23;
        } else if (string.equals("GDEF")) {
            n = 24;
        } else if (string.equals("JSTF")) {
            n = 25;
        } else if (string.equals("LTSH")) {
            n = 26;
        } else if (string.equals("PCLT")) {
            n = 27;
        } else if (string.equals("VDMX")) {
            n = 28;
        } else if (string.equals("mort")) {
            n = 30;
        } else if (string.equals("bsln")) {
            n = 29;
        } else if (string.equals("fdsc")) {
            n = 31;
        } else if (string.equals("FFTM")) {
            n = 32;
        } else if (string.equals("GPOS")) {
            n = 33;
        } else if (string.equals("feat")) {
            n = 34;
        } else if (string.equals("just")) {
            n = 35;
        } else if (string.equals("prop")) {
            n = 36;
        } else if (string.equals("LCCL")) {
            n = 37;
        } else if (string.equals("Zapf")) {
            n = 38;
        }
        return n;
    }

    public int selectTable(int n) {
        this.pointer = this.tables[n][this.currentFontID];
        return this.pointer;
    }

    public int getTableSize(int n) {
        return this.tableLength[n][this.currentFontID];
    }

    public int getTableStart(int n) {
        return this.tables[n][this.currentFontID];
    }

    public final int getNextUint32() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.useArray ? (this.pointer < this.fontDataAsArray.length ? this.fontDataAsArray[this.pointer] & 0xFF : 0) : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (3 - i);
            ++this.pointer;
        }
        return n;
    }

    public final int getNextUint64() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            n += n2 << 8 * (7 - i);
            ++this.pointer;
        }
        return n;
    }

    public final void setPointer(int n) {
        this.pointer = n;
    }

    public final int getOffset(int n) {
        return this.tableLength[n][this.currentFontID];
    }

    public final int getTable(int n) {
        return this.tables[n][this.currentFontID];
    }

    public final int getPointer() {
        return this.pointer;
    }

    public final String getNextUint32AsTag() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            char c = this.useArray ? (char)this.fontDataAsArray[this.pointer] : (char)this.fontDataAsObject.getByte(this.pointer);
            stringBuilder.append(c);
            ++this.pointer;
        }
        return stringBuilder.toString();
    }

    public final int getNextUint16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return n;
    }

    public final short getShort() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            byte by = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
            n += by << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public final int getNextUint8() {
        int n = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        ++this.pointer;
        return n;
    }

    public final int getNextint8() {
        byte by = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
        ++this.pointer;
        return by;
    }

    public void skip(int n) {
        this.pointer += n;
    }

    public short getFWord() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short getNextInt16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short getNextSignedInt16() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public short readUFWord() {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            n += n2 << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)n;
    }

    public float getFixed() {
        int n = this.useArray ? (this.fontDataAsArray[this.pointer] & 0xFF) * 256 + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : (this.fontDataAsObject.getByte(this.pointer) & 0xFF) * 256 + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        if (n > 32768) {
            n -= 65536;
        }
        this.pointer += 2;
        int n2 = this.useArray ? (this.fontDataAsArray[this.pointer] & 0xFF) * 256 + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : (this.fontDataAsObject.getByte(this.pointer) & 0xFF) * 256 + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        this.pointer += 2;
        return (float)n + (float)n2 / 65536.0f;
    }

    public String getString() {
        if (this.useArray && this.pointer == this.fontDataAsArray.length) {
            return "";
        }
        int n = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        char[] cArray = new char[n];
        ++this.pointer;
        for (int i = 0; i < n; ++i) {
            int n2 = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            ++this.pointer;
            cArray[i] = (char)n2;
            if (!this.useArray || this.pointer < this.fontDataAsArray.length) continue;
            i = n;
        }
        return String.copyValueOf(cArray);
    }

    public byte[] getStringBytes() {
        if (this.useArray && this.pointer == this.fontDataAsArray.length) {
            return new byte[1];
        }
        int n = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        byte[] byArray = new byte[n];
        ++this.pointer;
        for (int i = 0; i < n; ++i) {
            byte by = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
            ++this.pointer;
            byArray[i] = by;
            if (!this.useArray || this.pointer < this.fontDataAsArray.length) continue;
            i = n;
        }
        return byArray;
    }

    public float getF2Dot14() {
        int n = this.useArray ? ((this.fontDataAsArray[this.pointer] & 0xFF) << 8) + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : ((this.fontDataAsObject.getByte(this.pointer) & 0xFF) << 8) + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        this.pointer += 2;
        if (n == 49152) {
            return -1.0f;
        }
        if (n == 16384) {
            return 1.0f;
        }
        return (float)(n - 2 * (n & 0x8000)) / 16384.0f;
    }

    public byte[] readBytes(int n, int n2) {
        if (this.useArray) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.fontDataAsArray, n, byArray, 0, n2);
            return byArray;
        }
        return this.fontDataAsObject.getBytes(n, n2);
    }

    public byte[] getTableBytes(int n) {
        int n2 = this.tables[n][this.currentFontID];
        int n3 = this.tableLength[n][this.currentFontID];
        if (this.useArray) {
            byte[] byArray = new byte[n3];
            System.arraycopy(this.fontDataAsArray, n2, byArray, 0, n3);
            return byArray;
        }
        return this.fontDataAsObject.getBytes(n2, n3);
    }

    public int getType() {
        return this.type;
    }

    public int getFontCount() {
        return this.fontCount;
    }

    public boolean hasValuesLeft() {
        int n = this.useArray ? this.fontDataAsArray.length : this.fontDataAsObject.length();
        return this.pointer < n;
    }

    public int getBytesLeft() {
        int n = this.useArray ? this.fontDataAsArray.length : this.fontDataAsObject.length();
        return n - this.pointer;
    }
}

