/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.objects;

import java.io.File;

public class SignData {
    private boolean signMode;
    private boolean canEncrypt;
    private boolean flatten;
    private boolean isVisibleSignature;
    private String outputPath;
    private String keyFilePath;
    private String keyStorePath;
    private String alias;
    private String reason;
    private String location;
    private char[] keyFilePassword;
    private char[] keyStorePassword;
    private char[] aliasPassword;
    private char[] encryptUserPassword;
    private char[] encryptOwnerPassword;
    private int certifyMode;
    private int encryptPermissions;
    float x1;
    float y1;
    float x2;
    float y2;
    private File outputFile;
    private File keyFile;
    private boolean valid = false;
    private String invalidMessage;
    private int signaturePage;
    private boolean appendMode;

    public boolean isKeystoreSign() {
        return this.signMode;
    }

    public void setSignMode(boolean bl) {
        this.signMode = bl;
    }

    public void setOutputFilePath(String string) {
        this.outputPath = string;
    }

    public String getOutputFilePath() {
        return this.outputPath;
    }

    public File getOutput() {
        return this.outputFile;
    }

    public void setKeyFilePath(String string) {
        this.keyFilePath = string;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public void setKeyStorePath(String string) {
        this.keyStorePath = string;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public char[] getKeystorePassword() {
        return this.keyStorePassword;
    }

    public void setKeystorePassword(char[] cArray) {
        this.keyStorePassword = cArray;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public char[] getAliasPassword() {
        return this.aliasPassword;
    }

    public void setAliasPassword(char[] cArray) {
        this.aliasPassword = cArray;
    }

    public void setKeyFilePassword(char[] cArray) {
        this.keyFilePassword = cArray;
    }

    public char[] getKeyFilePassword() {
        return this.keyFilePassword;
    }

    public boolean canEncrypt() {
        return this.canEncrypt;
    }

    public void setEncrypt(boolean bl) {
        this.canEncrypt = bl;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public void setCertifyMode(int n) {
        this.certifyMode = n;
    }

    public int getCertifyMode() {
        return this.certifyMode;
    }

    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public boolean canFlatten() {
        return this.flatten;
    }

    public void setEncryptUserPass(char[] cArray) {
        this.encryptUserPassword = cArray;
    }

    public char[] getEncryptUserPass() {
        return this.encryptUserPassword;
    }

    public void setEncryptOwnerPass(char[] cArray) {
        this.encryptOwnerPassword = cArray;
    }

    public char[] getEncryptOwnerPass() {
        return this.encryptOwnerPassword;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setEncryptPermissions(int n) {
        this.encryptPermissions = n;
    }

    public int getEncryptPermissions() {
        return this.encryptPermissions;
    }

    public String toString() {
        String string;
        if (this.valid) {
            string = "Output File: " + this.outputFile.getAbsolutePath() + '\n';
            string = this.signMode ? string + "Keystore: " + this.keyStorePath + '\n' + "Alias: " + this.alias + '\n' : string + ".pfx File:" + this.keyFilePath + '\n';
        } else {
            return this.invalidMessage;
        }
        string = string + "Reason: \"" + this.reason + "\"\n" + "Location: " + this.location + '\n';
        if (this.canEncrypt()) {
            string = string + "Encrypt PDF\n";
        }
        if (this.canFlatten()) {
            string = string + "Flatten PDF\n";
        }
        if (this.certifyMode != -1) {
            string = string + "Certify PDF\n";
        }
        return string;
    }

    public boolean validate() {
        this.outputFile = new File(this.outputPath);
        if (this.outputFile.exists() || this.outputFile.isDirectory()) {
            this.invalidMessage = "Output file already exists.";
            this.valid = false;
            return false;
        }
        if (!this.signMode) {
            this.keyFile = new File(this.keyFilePath);
            if (!this.keyFile.exists() || this.keyFile.isDirectory()) {
                this.invalidMessage = "Key file not found.";
                this.valid = false;
                return false;
            }
        }
        this.valid = true;
        return true;
    }

    public boolean isVisibleSignature() {
        return this.isVisibleSignature;
    }

    public void setVisibleSignature(boolean bl) {
        this.isVisibleSignature = bl;
    }

    public void setRectangle(float f, float f2, float f3, float f4) {
        if (f < f3) {
            this.x1 = f;
            this.x2 = f3;
        } else {
            this.x2 = f;
            this.x1 = f3;
        }
        if (f2 < f4) {
            this.y1 = f2;
            this.y2 = f4;
        } else {
            this.y2 = f2;
            this.y1 = f4;
        }
    }

    public float[] getRectangle() {
        float[] fArray = new float[]{this.x1, this.y1, this.x2, this.y2};
        return fArray;
    }

    public int getSignPage() {
        return this.signaturePage;
    }

    public void setSignPage(int n) {
        this.signaturePage = n;
    }

    public void setAppend(boolean bl) {
        this.appendMode = bl;
    }

    public boolean isAppendMode() {
        return this.appendMode;
    }
}

