/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.javabean;

import java.io.File;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;

public class ViewerBean
extends JPanel {
    private Viewer viewer = new Viewer(this, "jar:/org/jpedal/examples/viewer/res/preferences/Bean.xml");
    private File document = null;
    private Integer pageNumber = null;
    private Integer rotation = null;
    private Integer zoom = null;
    private Boolean isMenuBarVisible = null;
    private Boolean isToolBarVisible = null;
    private Boolean isDisplayOptionsBarVisible = null;
    private Boolean isSideTabBarVisible = null;
    private Boolean isNavigationBarVisible = null;

    public ViewerBean() {
        this.viewer.setupViewer();
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void setDocument(File file) {
        this.document = file;
        this.excuteCommand(10, new String[]{String.valueOf(file)});
        if (this.pageNumber != null) {
            this.excuteCommand(56, new String[]{String.valueOf(this.pageNumber)});
        }
        if (this.rotation != null) {
            this.excuteCommand(251, new String[]{String.valueOf(this.rotation)});
        }
        if (this.zoom != null) {
            this.excuteCommand(252, new String[]{String.valueOf(this.zoom)});
        } else {
            this.excuteCommand(252, new String[]{String.valueOf(100)});
        }
        if (this.isMenuBarVisible != null) {
            this.setMenuBar(this.isMenuBarVisible);
        }
        if (this.isToolBarVisible != null) {
            this.setToolBar(this.isToolBarVisible);
        }
        if (this.isDisplayOptionsBarVisible != null) {
            this.setDisplayOptionsBar(this.isDisplayOptionsBarVisible);
        }
        if (this.isSideTabBarVisible != null) {
            this.setSideTabBar(this.isSideTabBarVisible);
        }
        if (this.isNavigationBarVisible != null) {
            this.setNavigationBar(this.isNavigationBarVisible);
        }
    }

    public int getPageNumber() {
        if (this.pageNumber == null) {
            return 1;
        }
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
        if (this.document != null) {
            this.excuteCommand(56, new String[]{String.valueOf(n)});
        }
    }

    public int getRotation() {
        if (this.rotation == null) {
            return 0;
        }
        return this.rotation;
    }

    public void setRotation(int n) {
        this.rotation = n;
        if (this.document != null) {
            this.excuteCommand(251, new String[]{String.valueOf(n)});
        }
    }

    public int getZoom() {
        if (this.zoom == null) {
            return 100;
        }
        return this.zoom;
    }

    public void setZoom(int n) {
        this.zoom = n;
        if (this.document != null) {
            this.excuteCommand(252, new String[]{String.valueOf(n)});
        }
    }

    public void setMenuBar(boolean bl) {
        this.isMenuBarVisible = bl;
        this.viewer.executeCommand(28, new Object[]{"ShowMenubar", bl});
    }

    public boolean getMenuBar() {
        if (this.isMenuBarVisible == null) {
            return true;
        }
        return this.isMenuBarVisible;
    }

    public void setToolBar(boolean bl) {
        this.isToolBarVisible = bl;
        this.viewer.executeCommand(28, new Object[]{"ShowButtons", bl});
    }

    public boolean getToolBar() {
        if (this.isToolBarVisible == null) {
            return true;
        }
        return this.isToolBarVisible;
    }

    public void setDisplayOptionsBar(boolean bl) {
        this.isDisplayOptionsBarVisible = bl;
        this.viewer.executeCommand(28, new Object[]{"ShowDisplayoptions", bl});
    }

    public boolean getDisplayOptionsBar() {
        if (this.isDisplayOptionsBarVisible == null) {
            return true;
        }
        return this.isDisplayOptionsBarVisible;
    }

    public void setSideTabBar(boolean bl) {
        this.isSideTabBarVisible = bl;
        this.viewer.executeCommand(28, new Object[]{"ShowSidetabbar", bl});
    }

    public boolean getSideTabBar() {
        if (this.isSideTabBarVisible == null) {
            return true;
        }
        return this.isSideTabBarVisible;
    }

    public void setNavigationBar(boolean bl) {
        this.isNavigationBarVisible = bl;
        this.viewer.executeCommand(28, new Object[]{"ShowNavigationbar", bl});
    }

    public boolean getNavigationBar() {
        if (this.isNavigationBarVisible == null) {
            return true;
        }
        return this.isNavigationBarVisible;
    }

    private void excuteCommand(final int n, final Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ViewerBean.this.viewer.executeCommand(n, objectArray);
                while (Values.isProcessing()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                ViewerBean.this.repaint();
            }
        });
    }
}

