/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.popups.Save;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class AddHeaderFooterToPDFPages
extends Save {
    private static final long serialVersionUID = -8681143216306570454L;
    JLabel OutputLabel = new JLabel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    ButtonGroup buttonGroup2 = new ButtonGroup();
    JToggleButton jToggleButton3 = new JToggleButton();
    JToggleButton jToggleButton2 = new JToggleButton();
    JRadioButton printAll = new JRadioButton();
    JRadioButton printCurrent = new JRadioButton();
    JRadioButton printPages = new JRadioButton();
    JTextField pagesBox = new JTextField();
    JTextField leftHeaderBox = new JTextField();
    JTextField centerHeaderBox = new JTextField();
    JTextField rightHeaderBox = new JTextField();
    JTextField leftFooterBox = new JTextField();
    JTextField centerFooterBox = new JTextField();
    JTextField rightFooterBox = new JTextField();
    JComboBox fontsList = new JComboBox<String>(new String[]{"Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic", "Symbol", "ZapfDingbats"});
    JSpinner fontSize = new JSpinner(new SpinnerNumberModel(10, 1, 100, 1));
    JLabel colorBox = new JLabel();
    JSpinner leftRightBox = new JSpinner(new SpinnerNumberModel(36.0, 1.0, 1000.0, 1.0));
    JSpinner topBottomBox = new JSpinner(new SpinnerNumberModel(36.0, 1.0, 1000.0, 1.0));
    JTextArea tagsList = new JTextArea();

    public AddHeaderFooterToPDFPages(String string, int n, int n2) {
        super(string, n, n2);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int[] getPages() {
        int[] nArray = null;
        if (this.printAll.isSelected()) {
            nArray = new int[this.end_page];
            for (int i = 0; i < this.end_page; ++i) {
                nArray[i] = i + 1;
            }
            return nArray;
        } else if (this.printCurrent.isSelected()) {
            nArray = new int[]{this.currentPage};
            return nArray;
        } else {
            if (!this.printPages.isSelected()) return nArray;
            try {
                PageRanges pageRanges = new PageRanges(this.pagesBox.getText());
                int n = 0;
                int n2 = -1;
                while ((n2 = pageRanges.next(n2)) != -1) {
                    ++n;
                }
                nArray = new int[n];
                n = 0;
                n2 = -1;
                while ((n2 = pageRanges.next(n2)) != -1) {
                    if (n2 > this.end_page) {
                        if (!Viewer.showMessages) return null;
                        JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerText.Page") + ' ' + n2 + ' ' + Messages.getMessage("PdfViewerError.OutOfBounds") + ' ' + Messages.getMessage("PdfViewerText.PageCount") + ' ' + this.end_page);
                        return null;
                    }
                    nArray[n] = n2;
                    ++n;
                }
                return nArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogWriter.writeLog(Messages.getMessage("PdfViewerError.Exception") + ' ' + illegalArgumentException + ' ' + Messages.getMessage("PdfViewerError.ExportPdfError"));
                if (!Viewer.showMessages) return nArray;
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.InvalidSyntax"));
            }
        }
        return nArray;
    }

    public float getLeftRightMargin() {
        return Float.parseFloat(this.leftRightBox.getValue().toString());
    }

    public float getTopBottomMargin() {
        return Float.parseFloat(this.topBottomBox.getValue().toString());
    }

    public String getFontName() {
        return (String)this.fontsList.getSelectedItem();
    }

    public int getFontSize() {
        return Integer.parseInt(this.fontSize.getValue().toString());
    }

    public Color getFontColor() {
        return this.colorBox.getBackground();
    }

    public String getLeftHeader() {
        return this.leftHeaderBox.getText();
    }

    public String getCenterHeader() {
        return this.centerHeaderBox.getText();
    }

    public String getRightHeader() {
        return this.rightHeaderBox.getText();
    }

    public String getLeftFooter() {
        return this.leftFooterBox.getText();
    }

    public String getCenterFooter() {
        return this.centerFooterBox.getText();
    }

    public String getRightFooter() {
        return this.rightFooterBox.getText();
    }

    private void jbInit() throws Exception {
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerLabel.TextAndFont"));
        jLabel.setFont(new Font("Dialog", 1, 14));
        jLabel.setDisplayedMnemonic('0');
        jLabel.setBounds(new Rectangle(13, 13, 220, 26));
        JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerLabel.Left"));
        jLabel2.setBounds(new Rectangle(130, 40, 50, 23));
        JLabel jLabel3 = new JLabel(Messages.getMessage("PdfViewerLabel.Center"));
        jLabel3.setBounds(new Rectangle(300, 40, 50, 23));
        JLabel jLabel4 = new JLabel(Messages.getMessage("PdfViewerLabel.Right"));
        jLabel4.setBounds(new Rectangle(475, 40, 50, 23));
        JLabel jLabel5 = new JLabel(Messages.getMessage("PdfViewerLabel.Header"));
        jLabel5.setBounds(new Rectangle(20, 60, 90, 23));
        JLabel jLabel6 = new JLabel(Messages.getMessage("PdfViewerLabel.Footer"));
        jLabel6.setBounds(new Rectangle(20, 90, 50, 23));
        this.leftHeaderBox.setBounds(new Rectangle(85, 60, 133, 23));
        this.centerHeaderBox.setBounds(new Rectangle(250, 60, 133, 23));
        this.rightHeaderBox.setBounds(new Rectangle(425, 60, 133, 23));
        this.leftFooterBox.setBounds(new Rectangle(85, 90, 133, 23));
        this.centerFooterBox.setBounds(new Rectangle(250, 90, 133, 23));
        this.rightFooterBox.setBounds(new Rectangle(425, 90, 133, 23));
        JLabel jLabel7 = new JLabel(Messages.getMessage("PdfViewerLabel.Font"));
        jLabel7.setBounds(new Rectangle(20, 120, 75, 23));
        this.fontsList.setBounds(new Rectangle(85, 120, 150, 23));
        this.fontsList.setSelectedItem("Helvetica");
        JLabel jLabel8 = new JLabel(Messages.getMessage("PdfViewerLabel.Size"));
        jLabel8.setBounds(new Rectangle(250, 120, 50, 23));
        this.fontSize.setBounds(new Rectangle(290, 120, 50, 23));
        JLabel jLabel9 = new JLabel(Messages.getMessage("PdfViewerLabel.Color"));
        jLabel9.setBounds(new Rectangle(360, 120, 50, 23));
        this.colorBox.setBackground(Color.black);
        this.colorBox.setOpaque(true);
        this.colorBox.setBounds(new Rectangle(410, 120, 23, 23));
        JButton jButton = new JButton(Messages.getMessage("PdfViewerButton.ChooseColor"));
        jButton.setBounds(new Rectangle(450, 120, 160, 23));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddHeaderFooterToPDFPages.this.colorBox.setBackground(JColorChooser.showDialog(null, "Color", AddHeaderFooterToPDFPages.this.colorBox.getBackground()));
            }
        });
        this.tagsList.setText("You may use the following\ntags as part of the text.\n\n<d> - Date in short format\n<D> - Date in long format\n<t> - Time in 12-hour format\n<T> - Time in 24-hour format\n<f> - Filename\n<F> - Full path filename\n<p> - Current page number\n<P> - Total number of pages");
        this.tagsList.setOpaque(false);
        this.tagsList.setBounds(350, 160, 200, 210);
        JLabel jLabel10 = new JLabel(Messages.getMessage("PdfViewerLabel.Margins"));
        jLabel10.setFont(new Font("Dialog", 1, 14));
        jLabel10.setDisplayedMnemonic('0');
        jLabel10.setBounds(new Rectangle(13, 150, 220, 26));
        JLabel jLabel11 = new JLabel(Messages.getMessage("PdfViewerLabel.LeftAndRight"));
        jLabel11.setBounds(new Rectangle(20, 185, 90, 23));
        this.leftRightBox.setBounds(new Rectangle(100, 185, 70, 23));
        JLabel jLabel12 = new JLabel(Messages.getMessage("PdfViewerLabel.TopAndBottom"));
        jLabel12.setBounds(new Rectangle(180, 185, 120, 23));
        this.topBottomBox.setBounds(new Rectangle(300, 185, 70, 23));
        this.pageRangeLabel.setText(Messages.getMessage("PdfViewerPageRange.text"));
        this.pageRangeLabel.setBounds(new Rectangle(13, 220, 400, 26));
        this.printAll.setText(Messages.getMessage("PdfViewerRadioButton.All"));
        this.printAll.setBounds(new Rectangle(23, 250, 75, 22));
        this.printCurrent.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printCurrent.setBounds(new Rectangle(23, 270, 100, 22));
        this.printCurrent.setSelected(true);
        this.printPages.setText(Messages.getMessage("PdfViewerRadioButton.Pages"));
        this.printPages.setBounds(new Rectangle(23, 292, 70, 22));
        this.pagesBox.setBounds(new Rectangle(95, 292, 230, 22));
        this.pagesBox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (AddHeaderFooterToPDFPages.this.pagesBox.getText().length() == 0) {
                    AddHeaderFooterToPDFPages.this.printCurrent.setSelected(true);
                } else {
                    AddHeaderFooterToPDFPages.this.printPages.setSelected(true);
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        JTextArea jTextArea = new JTextArea(Messages.getMessage("PdfViewerMessage.PageNumberOrRangeLong"));
        jTextArea.setBounds(new Rectangle(23, 320, 620, 40));
        jTextArea.setOpaque(false);
        this.add((Component)this.printAll, null);
        this.add((Component)this.printCurrent, null);
        this.add((Component)this.printPages, null);
        this.add((Component)this.pagesBox, null);
        this.add((Component)jTextArea, null);
        this.add((Component)jLabel2, null);
        this.add((Component)jLabel3, null);
        this.add((Component)jLabel4, null);
        this.add((Component)jLabel5, null);
        this.add((Component)jLabel6, null);
        this.add((Component)this.leftHeaderBox, null);
        this.add((Component)this.centerHeaderBox, null);
        this.add((Component)this.rightHeaderBox, null);
        this.add((Component)this.leftFooterBox, null);
        this.add((Component)this.centerFooterBox, null);
        this.add((Component)this.rightFooterBox, null);
        this.add((Component)jLabel7, null);
        this.add((Component)this.fontsList, null);
        this.add((Component)jLabel8, null);
        this.add((Component)this.fontSize, null);
        this.add((Component)jLabel9, null);
        this.add((Component)this.colorBox, null);
        this.add((Component)jButton, null);
        this.add((Component)jLabel10, null);
        this.add((Component)jLabel11, null);
        this.add((Component)this.leftRightBox, null);
        this.add((Component)jLabel12, null);
        this.add((Component)this.topBottomBox, null);
        this.add((Component)jLabel, null);
        this.add((Component)this.changeButton, null);
        this.add((Component)this.pageRangeLabel, null);
        this.add((Component)this.jToggleButton2, null);
        this.add((Component)this.jToggleButton3, null);
        this.buttonGroup1.add(this.printAll);
        this.buttonGroup1.add(this.printCurrent);
        this.buttonGroup1.add(this.printPages);
    }

    public final Dimension getPreferredSize() {
        return new Dimension(620, 350);
    }
}

