/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.BaseTransferHandler;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class MultiViewTransferHandler
extends BaseTransferHandler {
    private int fileCount = 0;

    public MultiViewTransferHandler(Values values, GUIThumbnailPanel gUIThumbnailPanel, SwingGUI swingGUI, Commands commands) {
        super(values, gUIThumbnailPanel, swingGUI, commands);
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        try {
            Object object = this.getImport(transferable);
            if (object instanceof String) {
                String string = (String)object;
                System.out.println(string);
                String string2 = string.toLowerCase();
                if (string2.startsWith("http:/")) {
                    this.currentCommands.openTransferedFile(string2);
                    return true;
                }
                if (string2.startsWith("file:/")) {
                    String[] stringArray = string.split("file:/");
                    LinkedList<File> linkedList = new LinkedList<File>();
                    for (String string3 : stringArray) {
                        if (string3.length() <= 0) continue;
                        File file = new File(new URL("file:/" + string3).getFile());
                        System.out.println(file);
                        linkedList.add(file);
                    }
                    return this.openFiles(linkedList);
                }
            } else if (object instanceof List) {
                List list = (List)object;
                return this.openFiles(list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean openFiles(List list) {
        Object object;
        this.fileCount = 0;
        List list2 = this.getFlattenedFiles(list, new ArrayList());
        if (this.fileCount == this.commonValues.getMaxMiltiViewers()) {
            this.currentGUI.showMessageDialog((Object)("You have choosen to import more files than your current set maximum (" + this.commonValues.getMaxMiltiViewers() + ").  Only the first " + this.commonValues.getMaxMiltiViewers() + " files will be imported.\nYou can change this value " + "in View | Preferences"), "Maximum number of files reached", 1);
        }
        List[] listArray = MultiViewTransferHandler.filterFiles(list2);
        final List list3 = listArray[0];
        List list4 = listArray[1];
        int n = list4.size();
        int n2 = list3.size();
        if (n > 0) {
            object = "";
            for (Object e : list4) {
                String string = (String)e;
                String string2 = new File(string).getName();
                object = (String)object + string2 + '\n';
            }
            int n3 = this.currentGUI.showConfirmDialog("You have selected " + list2.size() + " files to open.  The following file(s) cannot be opened\nas they are not valid PDFs " + "or images.\n" + (String)object + "\nWould you like to open the remaining " + n2 + " files?", "File Import", 0, 3);
            if (n3 == 1) {
                return false;
            }
        }
        object = new SwingWorker(){

            public Object construct() {
                for (Object e : list3) {
                    String string = (String)e;
                    try {
                        MultiViewTransferHandler.this.currentCommands.openTransferedFile(string);
                    }
                    catch (Exception exception) {
                        int n;
                        if (list3.size() == 1) {
                            MultiViewTransferHandler.this.currentGUI.showMessageDialog((Object)Messages.getMessage("PdfViewerOpenerror"), MultiViewTransferHandler.this.commonValues.getSelectedFile(), 0);
                            n = 1;
                        } else {
                            n = MultiViewTransferHandler.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerOpenerror") + ". Continue opening remaining files?", MultiViewTransferHandler.this.commonValues.getSelectedFile(), 0, 3);
                        }
                        MultiViewTransferHandler.this.currentGUI.closeMultiViewerWindow(MultiViewTransferHandler.this.commonValues.getSelectedFile());
                        if (n != 1) continue;
                        return null;
                    }
                }
                return null;
            }
        };
        ((SwingWorker)object).start();
        return true;
    }

    private static List[] filterFiles(List list) {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (Object e : list) {
            boolean bl;
            String string = (String)e;
            String string2 = string.toLowerCase();
            boolean bl2 = bl = string2.endsWith(".pdf") || string2.endsWith(".fdf") || string2.endsWith(".tif") || string2.endsWith(".tiff") || string2.endsWith(".png") || string2.endsWith(".jpg") || string2.endsWith(".jpeg");
            if (bl) {
                linkedList.add(string);
                continue;
            }
            linkedList2.add(string);
        }
        return new List[]{linkedList, linkedList2};
    }

    private List getFlattenedFiles(List list, List list2) {
        for (Object e : list) {
            if (this.fileCount == this.commonValues.getMaxMiltiViewers()) {
                return list2;
            }
            File file = (File)e;
            if (file.isDirectory()) {
                this.getFlattenedFiles(Arrays.asList(file.listFiles()), list2);
                continue;
            }
            list2.add(file.getAbsolutePath());
            ++this.fileCount;
        }
        return list2;
    }
}

