/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class DeviceGrayColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = -8160089076145994695L;

    public DeviceGrayColorSpace() {
        this.value = 1568372915;
        this.cs = ColorSpace.getInstance(1003);
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[]{Float.parseFloat(stringArray[0])};
        this.setColor(fArray, 1);
    }

    public final void setColor(float[] fArray, int n) {
        float f = fArray[0];
        int n2 = f <= 1.0f ? (int)(255.0f * f) : (int)f;
        if (n2 < 0) {
            n2 = 0;
        }
        this.currentColor = new PdfColor(n2, n2, n2);
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            for (int j = 0; j < 3; ++j) {
                byArray2[i * 3 + j] = by;
            }
        }
        return byArray2;
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        BufferedImage bufferedImage;
        block9: {
            ImageInputStream imageInputStream;
            ImageReader imageReader;
            ByteArrayInputStream byteArrayInputStream;
            block8: {
                if (pdfObject != null && pdfObject instanceof MaskObject) {
                    return super.JPEGToRGBImage(byArray, n, n2, fArray, n3, n4, bl, pdfObject);
                }
                byteArrayInputStream = null;
                imageReader = null;
                imageInputStream = null;
                try {
                    Object object;
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext() && !(imageReader = (object = iterator.next())).canReadRaster()) {
                    }
                    ImageIO.setUseCache(false);
                    imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    imageReader.setInput(imageInputStream, true);
                    object = imageReader.readRaster(0, null);
                    object = DeviceGrayColorSpace.cleanupRaster((Raster)object, n3, n4, 1);
                    int n5 = ((Raster)object).getWidth();
                    int n6 = ((Raster)object).getHeight();
                    DataBufferByte dataBufferByte = (DataBufferByte)((Raster)object).getDataBuffer();
                    byte[] byArray2 = dataBufferByte.getData();
                    int n7 = byArray2.length;
                    byte[] byArray3 = new byte[n7 * 3];
                    int n8 = 0;
                    for (int i = 0; i < n7; ++i) {
                        if (bl) {
                            byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
                        }
                        byArray3[n8] = byArray2[i];
                        byArray3[++n8] = byArray2[i];
                        byArray3[++n8] = byArray2[i];
                        ++n8;
                    }
                    int[] nArray = new int[]{0, 1, 2};
                    bufferedImage = new BufferedImage(n5, n6, 1);
                    WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n5, n6, n5 * 3, 3, nArray, null);
                    bufferedImage.setData(writableRaster);
                }
                catch (Exception exception) {
                    bufferedImage = null;
                    if (!LogWriter.isOutput()) break block8;
                    LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
                }
            }
            try {
                byteArrayInputStream.close();
                imageReader.dispose();
                imageInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Problem closing  " + exception);
            }
        }
        return bufferedImage;
    }
}

