/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PdfStreamDecoderForSampling;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageDisplay;

public class PDFtoImageConvertor {
    public static Boolean allowPagesSmallerThanPageSize = Boolean.FALSE;
    public static Integer bestQualityMaxScaling = null;
    private float multiplyer = 1.0f;
    Boolean instance_allowPagesSmallerThanPageSize;
    DynamicVectorRenderer htmlDisplay;
    DecoderOptions options = null;
    private Integer instance_bestQualityMaxScaling = null;

    public PDFtoImageConvertor(float f, DecoderOptions decoderOptions) {
        this.multiplyer = f;
        this.instance_allowPagesSmallerThanPageSize = decoderOptions.getInstance_allowPagesSmallerThanPageSize();
        this.instance_bestQualityMaxScaling = decoderOptions.getInstance_bestQualityMaxScaling();
        this.options = decoderOptions;
    }

    public BufferedImage convert(DecoderResults decoderResults, int n, PdfResources pdfResources, int n2, ExternalHandlers externalHandlers, int n3, PdfPageData pdfPageData, AcroRenderer acroRenderer, float f, PdfObjectReader pdfObjectReader, int n4, boolean bl, String string) throws PdfException {
        int n5;
        int n6;
        int n7;
        Object object;
        PageObject pageObject = new PageObject(string);
        pdfObjectReader.readObject(pageObject);
        pdfObjectReader.checkParentForResources(pageObject);
        PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
        ObjectStore objectStore = new ObjectStore(null);
        ImageDisplay imageDisplay = new ImageDisplay(n4, true, 5000, objectStore);
        if (imageDisplay.getType() != 4 && imageDisplay.getType() != 5 && imageDisplay.getType() != 6) {
            if (this.options.getPageColor() != null) {
                imageDisplay.setValue(1, this.options.getPageColor().getRGB());
            }
            if (this.options.getTextColor() != null) {
                imageDisplay.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    imageDisplay.setValue(3, 1);
                } else {
                    imageDisplay.setValue(3, 0);
                }
                imageDisplay.setValue(4, this.options.getReplacementColorThreshold());
            }
        }
        if (this.htmlDisplay != null) {
            imageDisplay.writeCustom(24, this.htmlDisplay);
        }
        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(pdfObjectReader);
        if (this.htmlDisplay == null) {
            pdfStreamDecoder.setParameters(true, true, n3, 0);
        } else {
            pdfStreamDecoder.setParameters(true, true, n3, 1);
        }
        externalHandlers.addHandlers(pdfStreamDecoder);
        pdfStreamDecoder.setObjectValue(-8, objectStore);
        pdfStreamDecoder.setFloatValue(17, this.multiplyer);
        pdfStreamDecoder.setObjectValue(-18, pdfPageData);
        pdfStreamDecoder.setIntValue(-10, n4);
        pdfStreamDecoder.setObjectValue(23, imageDisplay);
        pdfResources.setupResources(pdfStreamDecoder, true, pdfObject, n4, pdfObjectReader);
        if (this.multiplyer == -2.0f) {
            this.multiplyer = -1.0f;
            pdfStreamDecoder.setFloatValue(17, this.multiplyer);
            object = new PdfStreamDecoderForSampling(pdfObjectReader);
            ((PdfStreamDecoder)object).setParameters(true, true, n3, 0);
            ((PdfStreamDecoder)object).setObjectValue(-8, objectStore);
            ((BaseDecoder)object).setFloatValue(17, this.multiplyer);
            ((PdfStreamDecoder)object).setObjectValue(-18, pdfPageData);
            ((PdfStreamDecoder)object).setIntValue(-10, n4);
            ((PdfStreamDecoder)object).setObjectValue(23, imageDisplay);
            pdfResources.setupResources((PdfStreamDecoder)object, true, pdfObject, n4, pdfObjectReader);
            this.multiplyer = ((PdfStreamDecoderForSampling)object).decodePageContentForImageSampling(pageObject);
            n7 = 0;
            if (this.instance_bestQualityMaxScaling != null) {
                n7 = this.instance_bestQualityMaxScaling;
            } else if (bestQualityMaxScaling != null) {
                n7 = bestQualityMaxScaling;
            }
            if (n7 > 0 && this.multiplyer > (float)n7) {
                this.multiplyer = n7;
            }
            ((BaseDecoder)object).setFloatValue(17, this.multiplyer);
            pdfStreamDecoder.setFloatValue(17, this.multiplyer);
        }
        if (!allowPagesSmallerThanPageSize.booleanValue() && !this.instance_allowPagesSmallerThanPageSize.booleanValue() && this.multiplyer < 1.0f && this.multiplyer > 0.0f) {
            this.multiplyer = 1.0f;
        }
        if (this.multiplyer == -1.0f) {
            this.multiplyer = 1.0f;
        }
        object = PDFtoImageConvertor.setPageParametersForImage(f * this.multiplyer, n4, pdfPageData);
        n7 = (int)(f * (float)pdfPageData.getMediaBoxHeight(n4));
        int n8 = pdfPageData.getRotation(n4);
        int n9 = (int)(f * (float)pdfPageData.getCropBoxWidth(n4));
        int n10 = (int)(f * (float)pdfPageData.getCropBoxHeight(n4));
        int n11 = (int)(f * (float)pdfPageData.getCropBoxX(n4));
        int n12 = (int)(f * (float)pdfPageData.getCropBoxY(n4));
        boolean bl2 = false;
        if (n8 == 90 || n8 == 270) {
            n6 = (int)((float)n9 * this.multiplyer);
            n5 = (int)((float)n10 * this.multiplyer);
            bl2 = true;
        } else {
            n5 = (int)((float)n9 * this.multiplyer);
            n6 = (int)((float)n10 * this.multiplyer);
        }
        BufferedImage bufferedImage = new BufferedImage(n5, n6, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n5, n6);
        }
        if (n8 == 180) {
            graphics2D.translate((float)(n11 * 2) * this.multiplyer, -((float)(n12 * 2) * this.multiplyer));
        }
        ((DynamicVectorRenderer)pdfStreamDecoder.getObjectValue(23)).setScalingValues((float)n11 * this.multiplyer, (float)n10 * this.multiplyer + (float)n12, this.multiplyer * f);
        graphics2D.setRenderingHints(ColorSpaces.hints);
        graphics2D.transform((AffineTransform)object);
        if (bl2) {
            if (n8 == 90) {
                if (this.multiplyer < 1.0f) {
                    n12 = (int)(((AffineTransform)object).getTranslateX() + (double)n12);
                    n11 = (int)(((AffineTransform)object).getTranslateY() + (double)n11);
                } else {
                    n12 = (int)(((AffineTransform)object).getTranslateX() / (double)this.multiplyer + (double)n12);
                    n11 = (int)(((AffineTransform)object).getTranslateY() / (double)this.multiplyer + (double)n11);
                }
                graphics2D.translate(-n11, -n12);
            } else if (n12 < 0) {
                graphics2D.translate(-n11, n7 - n10 + n12);
            } else {
                graphics2D.translate(-n11, n7 - n10 - n12);
            }
        }
        pdfStreamDecoder.setObjectValue(-7, graphics2D);
        imageDisplay.setG2(graphics2D);
        if (pageObject != null) {
            pdfStreamDecoder.setObjectValue(24, this.htmlDisplay);
            pdfStreamDecoder.decodePageContent(pageObject);
        }
        graphics2D.setClip(null);
        decoderResults.update(pdfStreamDecoder, false);
        if (acroRenderer != null && acroRenderer.hasFormsOnPage(n4) && !acroRenderer.ignoreForms()) {
            decoderResults.resetColorSpaces();
            acroRenderer.createDisplayComponentsForPage(n4, pdfStreamDecoder);
            acroRenderer.getCompData().renderFormsOntoG2(graphics2D, n4, f, 0, n, null, null, pdfObjectReader, pdfPageData.getMediaBoxHeight(n4));
        }
        objectStore.flush();
        return bufferedImage;
    }

    public float getMultiplyer() {
        return this.multiplyer;
    }

    private static AffineTransform setPageParametersForImage(float f, int n, PdfPageData pdfPageData) {
        AffineTransform affineTransform = new AffineTransform();
        int n2 = pdfPageData.getCropBoxWidth(n);
        int n3 = pdfPageData.getCropBoxHeight(n);
        int n4 = pdfPageData.getCropBoxX(n);
        int n5 = pdfPageData.getCropBoxY(n);
        int n6 = (int)((float)n2 * f);
        int n7 = (int)((float)n3 * f);
        int n8 = pdfPageData.getRotation(n);
        affineTransform.translate((float)(-n4) * f, (float)n5 * f);
        if (n8 == 270) {
            affineTransform.rotate(-1.5707963267948966, n6 / 2, n7 / 2);
            double d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            affineTransform.translate((double)n7 - d2, -d);
            affineTransform.translate((float)(2 * n5) * f, 0.0);
            affineTransform.translate(0.0, -f * (float)(pdfPageData.getCropBoxHeight(n) - pdfPageData.getMediaBoxHeight(n)));
        } else if (n8 == 180) {
            affineTransform.rotate(Math.PI, n6 / 2, n7 / 2);
        } else if (n8 == 90) {
            affineTransform.rotate(1.5707963267948966, n6 / 2, n7 / 2);
            double d = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            affineTransform.translate(-d3, (double)n6 - d);
        }
        if (f < 1.0f) {
            affineTransform.translate(n6, n7);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n6, 0.0);
            affineTransform.scale(f, f);
        } else {
            affineTransform.translate(n6, n7);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n6, 0.0);
            affineTransform.scale(f, f);
        }
        return affineTransform;
    }

    public void setHTMLInvisibleTextHandler(DynamicVectorRenderer dynamicVectorRenderer) {
        this.htmlDisplay = dynamicVectorRenderer;
    }
}

