/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.textalign;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.docx4j.org.capaxit.imagegenerator.TextWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GreedyTextWrapper
implements TextWrapper {
    private static final String SPACE = " ";
    private static final char CSPACE = ' ';

    @Override
    public List<String> doWrap(String text, int lineWidth, FontMetrics fm) {
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, SPACE);
        int spaceLeft = lineWidth;
        StringBuilder builder = new StringBuilder();
        boolean removed = false;
        String word = "";
        block0: while (tokenizer.hasMoreTokens()) {
            if (removed) {
                removed = false;
            } else {
                word = tokenizer.nextToken() + SPACE;
            }
            char[] chars = new char[word.length()];
            word.getChars(0, word.length(), chars, 0);
            for (int i = 0; i < chars.length; ++i) {
                boolean nospaceleft;
                if (fm.charWidth(chars[i]) > spaceLeft) {
                    if (chars[i] != ' ') {
                        builder.delete(builder.length() - i, builder.length());
                        removed = true;
                    }
                    if (builder.charAt(builder.length() - 1) == ' ') {
                        builder.delete(builder.length() - 1, builder.length());
                    }
                    lines.add(builder.toString());
                    spaceLeft = lineWidth;
                    builder.setLength(0);
                    nospaceleft = true;
                } else {
                    spaceLeft -= fm.charWidth(chars[i]);
                    nospaceleft = false;
                }
                if (removed || nospaceleft) continue block0;
                builder.append(chars[i]);
            }
        }
        if (removed) {
            builder.append(word.trim());
        }
        if (builder.length() > 1 && builder.charAt(builder.length() - 1) == ' ') {
            builder.delete(builder.length() - 1, builder.length());
        }
        lines.add(builder.toString());
        return lines;
    }
}

