/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.org.capaxit.imagegenerator.Align;
import org.docx4j.org.capaxit.imagegenerator.Alignment;
import org.docx4j.org.capaxit.imagegenerator.DrawableText;
import org.docx4j.org.capaxit.imagegenerator.Margin;
import org.docx4j.org.capaxit.imagegenerator.Style;
import org.docx4j.org.capaxit.imagegenerator.TextImage;
import org.docx4j.org.capaxit.imagegenerator.TextImageCallback;
import org.docx4j.org.capaxit.imagegenerator.TextWrapper;
import org.docx4j.org.capaxit.imagegenerator.textalign.Center;
import org.docx4j.org.capaxit.imagegenerator.textalign.GreedyTextWrapper;
import org.docx4j.org.capaxit.imagegenerator.textalign.Justify;
import org.docx4j.org.capaxit.imagegenerator.textalign.LeftAlign;
import org.docx4j.org.capaxit.imagegenerator.textalign.RightAlign;
import org.docx4j.org.capaxit.imagegenerator.util.Validate;

public final class TextImageImpl
implements TextImage {
    private static final String JPEG = "jpeg";
    private static final int MAX_COMPRESSION = 1;
    private static final String PNG = "png";
    private final int width;
    private final int height;
    private int xPos = 0;
    private int yPos = 0;
    private Style style = Style.PLAIN;
    private Alignment alignment = Alignment.LEFT;
    private Margin margin = new Margin(0, 0, 0, 0);
    private boolean wrap = false;
    private TextWrapper wrapper = new GreedyTextWrapper();
    private final BufferedImage image;
    private final Graphics2D graphics;
    private Font previouslyUsedFont = new Font("SansSerif", 0, 12);
    private Color previouslyUsedColor = Color.BLACK;
    private final Map<Alignment, Align> alignments = new HashMap<Alignment, Align>();

    public TextImageImpl(int width, int height) {
        this.alignments.put(Alignment.LEFT, new LeftAlign());
        this.alignments.put(Alignment.RIGHT, new RightAlign());
        this.alignments.put(Alignment.CENTER, new Center());
        this.alignments.put(Alignment.JUSTIFY, new Justify());
        this.width = width;
        this.height = height;
        this.image = new BufferedImage(width, height, 2);
        this.graphics = this.image.createGraphics();
        this.graphics.setBackground(new Color(255, 255, 255));
        this.graphics.setColor(new Color(0, 0, 0));
        this.graphics.clearRect(0, 0, width, height);
    }

    public TextImageImpl(int width, int height, Margin margin) {
        this(width, height);
        this.margin = Validate.notNull(margin, "The margin may not be null.");
        this.yPos = this.margin.getTop();
        this.xPos = this.margin.getLeft();
    }

    public TextImage useTextWrapper(TextWrapper wrapper) {
        this.wrapper = Validate.notNull(wrapper, "The wrapper may not be null.");
        return this;
    }

    public TextImage performAction(TextImageCallback callback) {
        Validate.notNull(callback, "The callback may not be null.");
        callback.doWithGraphics(this.graphics);
        return this;
    }

    public TextImage addHSpace(int space) {
        this.xPos += space;
        return this;
    }

    public TextImage addVSpace(int space) {
        this.yPos += space;
        return this;
    }

    public TextImage wrap(boolean enable) {
        this.wrap = enable;
        return this;
    }

    public TextImage write(String text) {
        Validate.notNull(text, "The text may not be null.");
        FontMetrics fm = this.getFontMetrics();
        if (this.wrap) {
            int lineWidth = this.width - this.margin.getLeft() - this.margin.getRight();
            List<String> lines = this.wrapper.doWrap(text, lineWidth, fm);
            for (String line : lines) {
                this.writeText(fm, line);
                this.applyStyle(fm, line);
                this.newLine();
            }
        } else {
            this.writeText(fm, text);
            this.applyStyle(fm, text);
        }
        return this;
    }

    private void applyStyle(FontMetrics fm, String line) {
        if (this.style.equals((Object)Style.UNDERLINED)) {
            int y = this.yPos + fm.getAscent();
            this.graphics.drawLine(this.xPos - fm.stringWidth(line), y, this.xPos, y);
        }
    }

    private void writeText(FontMetrics fm, String text) {
        int linewidth = this.width - this.margin.getLeft() - this.margin.getRight();
        List<DrawableText> words = this.alignments.get((Object)this.alignment).align(text, fm, linewidth);
        for (DrawableText word : words) {
            this.graphics.drawString(word.getText(), this.xPos + word.getXPos(), this.yPos + this.getFontMetrics().getAscent() - this.getFontMetrics().getDescent());
        }
        this.xPos += fm.stringWidth(text);
    }

    public TextImage write(String text, int yOffset) {
        Validate.notNull(text, "The text may not be null.");
        int oldY = this.yPos;
        this.yPos += yOffset;
        this.write(text);
        this.yPos = oldY;
        return this;
    }

    public TextImage writeLine(String text) {
        this.graphics.drawString(text, this.xPos, this.yPos + this.getFontMetrics().getAscent() - this.getFontMetrics().getDescent());
        this.newLine();
        return this;
    }

    private FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics(this.previouslyUsedFont);
    }

    public TextImage newLine() {
        this.yPos += this.getFontMetrics().getHeight();
        this.xPos = this.margin.getLeft();
        return this;
    }

    public TextImage newLine(int times) {
        this.yPos += times * this.getFontMetrics().getHeight();
        this.xPos = this.margin.getLeft();
        return this;
    }

    public TextImage withFont(Font font) {
        this.previouslyUsedFont = Validate.notNull(font, "The font may not be null.");
        this.graphics.setFont(font);
        return this;
    }

    public TextImage setTextAligment(Alignment alignment) {
        this.alignment = Validate.notNull(alignment, "The alignment may not be null.");
        return this;
    }

    public TextImage withFontStyle(Style style) {
        this.style = Validate.notNull(style, "The style may not be null.");
        return this;
    }

    public TextImage withColor(Color color) {
        this.previouslyUsedColor = Validate.notNull(color, "The color may not be null.");
        this.graphics.setColor(color);
        return this;
    }

    public TextImage write(Image image) {
        Validate.notNull(image, "The image may not be null.");
        int iWidth = ((BufferedImage)image).getWidth();
        int iHeight = ((BufferedImage)image).getHeight();
        int y = this.yPos + this.getFontMetrics().getAscent() - iHeight;
        this.graphics.drawImage(image, this.xPos, y, null);
        this.xPos += iWidth;
        return this;
    }

    public TextImage write(Image image, int yOffset) {
        Validate.notNull(image, "The image may not be null.");
        int oldY = this.yPos;
        this.yPos += yOffset;
        this.write(image);
        this.yPos = oldY;
        return this;
    }

    public TextImage writeLine(Image image) {
        Validate.notNull(image, "The image may not be null.");
        int iHeight = ((BufferedImage)image).getHeight();
        int y = this.yPos + this.getFontMetrics().getAscent() - iHeight;
        this.graphics.drawImage(image, this.xPos, y, null);
        this.newLine();
        return this;
    }

    public TextImage write(Image image, int x, int y) {
        Validate.notNull(image, "The image may not be null.");
        this.graphics.drawImage(image, x, y, null);
        return this;
    }

    public void setMargin(Margin margin) {
        Validate.notNull(margin, "The margin may not be null.");
        this.xPos = margin.getTop();
        this.yPos = margin.getLeft();
        this.margin = margin;
    }

    public Font getCurrentFont() {
        return this.previouslyUsedFont;
    }

    public Color getCurrentColor() {
        return this.previouslyUsedColor;
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

