/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.imageexporter.exporters;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.docx4j.org.capaxit.imagegenerator.TextImage;
import org.docx4j.org.capaxit.imagegenerator.imageexporter.ImageWriter;
import org.docx4j.org.capaxit.imagegenerator.impl.TextImageImpl;
import org.docx4j.org.capaxit.imagegenerator.util.Validate;

public final class PngImageWriter
implements ImageWriter {
    private static final String PNG = "png";

    public void writeImageToOutputStream(TextImage image, OutputStream outputStream) throws IOException {
        Validate.notNull(image, "The image may not be null.");
        Validate.notNull(outputStream, "The outputStream may not be null.");
        ImageIO.write((RenderedImage)((TextImageImpl)image).getBufferedImage(), PNG, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImageToFile(TextImage image, File file) throws IOException {
        Validate.notNull(image, "The image may not be null.");
        Validate.notNull(file, "The file may not be null.");
        FileOutputStream os = new FileOutputStream(file);
        try {
            ImageIO.write((RenderedImage)((TextImageImpl)image).getBufferedImage(), PNG, os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

