/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.imageexporter.exporters;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.docx4j.org.capaxit.imagegenerator.TextImage;
import org.docx4j.org.capaxit.imagegenerator.imageexporter.ImageWriter;
import org.docx4j.org.capaxit.imagegenerator.impl.TextImageImpl;
import org.docx4j.org.capaxit.imagegenerator.util.Validate;

public final class JpegImageWriter
implements ImageWriter {
    private static final int MAX_COMPRESSION_QUALITY = 1;

    public void writeImageToOutputStream(TextImage image, OutputStream outputStream) throws IOException {
        Validate.notNull(image, "The image may not be null.");
        Validate.notNull(outputStream, "The outputStream may not be null.");
        this.compressJpegStream(outputStream, image);
    }

    public void writeImageToFile(TextImage image, File file) throws IOException {
        Validate.notNull(image, "The image may not be null.");
        Validate.notNull(file, "The file may not be null.");
        FileOutputStream outputStream = new FileOutputStream(file);
        this.compressJpegStream(outputStream, image);
    }

    private void compressJpegStream(OutputStream outputStream, TextImage image) throws IOException {
        javax.imageio.ImageWriter jpegWriter = this.getJpegWriter();
        ImageWriteParam imageWriteParam = this.getHighestCompressionQualityParams();
        this.writeImageToOutputStream(outputStream, image, jpegWriter, imageWriteParam);
    }

    private javax.imageio.ImageWriter getJpegWriter() {
        javax.imageio.ImageWriter writer = null;
        Iterator<javax.imageio.ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
        if (iter.hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    private ImageWriteParam getHighestCompressionQualityParams() {
        JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault()){

            public void setCompressionQuality(float quality) {
                this.compressionQuality = quality;
            }
        };
        iwparam.setCompressionMode(2);
        iwparam.setCompressionQuality(1.0f);
        return iwparam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageToOutputStream(OutputStream outputStream, TextImage image, javax.imageio.ImageWriter jpegWriter, ImageWriteParam imageWriteParam) throws IOException {
        ImageOutputStream ios = ImageIO.createImageOutputStream(outputStream);
        try {
            jpegWriter.setOutput(ios);
            jpegWriter.write(null, new IIOImage(((TextImageImpl)image).getBufferedImage(), null, null), imageWriteParam);
        }
        finally {
            this.cleanUp(jpegWriter, ios);
        }
    }

    private void cleanUp(javax.imageio.ImageWriter jpegWriter, ImageOutputStream ios) throws IOException {
        ios.flush();
        jpegWriter.dispose();
        ios.close();
    }
}

