/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.imageexporter;

import org.docx4j.org.capaxit.imagegenerator.imageexporter.ImageType;
import org.docx4j.org.capaxit.imagegenerator.imageexporter.ImageWriter;
import org.docx4j.org.capaxit.imagegenerator.imageexporter.exporters.JpegImageWriter;
import org.docx4j.org.capaxit.imagegenerator.imageexporter.exporters.PngImageWriter;

public final class ImageWriterFactory {
    private static final ImageWriter JPEG_IMAGE_WRITER = new JpegImageWriter();
    private static final ImageWriter PNG_IMAGE_WRITER = new PngImageWriter();

    private ImageWriterFactory() {
    }

    public static ImageWriter getImageWriter(ImageType imageType) {
        switch (imageType) {
            case PNG: {
                return PNG_IMAGE_WRITER;
            }
            case JPEG: {
                return JPEG_IMAGE_WRITER;
            }
        }
        throw new IllegalStateException("No imagewriter defined for imageType[" + (Object)((Object)imageType) + "].");
    }
}

