/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.imagecallbacks;

import java.awt.Color;
import java.awt.Graphics2D;
import org.docx4j.org.capaxit.imagegenerator.TextImage;
import org.docx4j.org.capaxit.imagegenerator.TextImageCallback;
import org.docx4j.org.capaxit.imagegenerator.util.Validate;

public final class BackgroundColorCallback
implements TextImageCallback {
    private final Color backgroundColor;
    private final Color textColor;
    private final TextImage textImage;

    public BackgroundColorCallback(Color backgroundColor, Color textColor, TextImage textImage) {
        this.backgroundColor = Validate.notNull(backgroundColor, " The backgroundColor may not be null.");
        this.textColor = Validate.notNull(textColor, " The textColor may not be null.");
        this.textImage = Validate.notNull(textImage, " The textImage may not be null.");
    }

    public void doWithGraphics(Graphics2D graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.textImage.getWidth(), this.textImage.getHeight());
        graphics.setColor(this.textColor);
    }
}

