/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.html;

import java.util.HashMap;
import java.util.Map;
import org.docx4j.org.capaxit.imagegenerator.TextImage;
import org.docx4j.org.capaxit.imagegenerator.html.tags.Break;
import org.docx4j.org.capaxit.imagegenerator.html.tags.Paragraph;
import org.docx4j.org.capaxit.imagegenerator.html.tags.Tag;
import org.docx4j.org.capaxit.imagegenerator.html.tags.Underline;
import org.docx4j.org.capaxit.imagegenerator.impl.TextImageImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TextImageHtmlHandler
extends DefaultHandler {
    private int tagNestLevel = 0;
    private boolean charactersAlreadyWritten;
    private static final Map<String, Tag> tagImplementationMap = new HashMap<String, Tag>();
    private final TextImage textImage;
    private StringBuilder sb = new StringBuilder(100);

    public TextImageHtmlHandler() {
        this.textImage = new TextImageImpl(300, 300);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sb.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.sb.setLength(0);
        Tag tag = tagImplementationMap.get(qName.toLowerCase());
        if (tag != null) {
            this.tagNestLevel = tag.start(this.textImage, this.tagNestLevel);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.tagNestLevel;
        Tag tag = tagImplementationMap.get(qName.toLowerCase());
        if (tag != null) {
            tag.end(this.textImage, this.sb.toString(), this.charactersAlreadyWritten);
        }
        this.reset();
    }

    private void reset() {
        if (this.tagNestLevel <= 0) {
            this.charactersAlreadyWritten = false;
            this.tagNestLevel = 0;
        }
    }

    public TextImage getTextImage() {
        return this.textImage;
    }

    static {
        tagImplementationMap.put("u", new Underline());
        tagImplementationMap.put("p", new Paragraph());
        tagImplementationMap.put("br", new Break());
    }
}

