/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.html;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.ccil.cowan.tagsoup.jaxp.SAXParserImpl;
import org.docx4j.org.capaxit.imagegenerator.TextImage;
import org.docx4j.org.capaxit.imagegenerator.html.HtmlParseException;
import org.docx4j.org.capaxit.imagegenerator.html.TextImageHtmlHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class HtmlTextImageFactory {
    private HtmlTextImageFactory() {
    }

    public static TextImage fromHtml(String html) {
        try {
            TextImageHtmlHandler handler = new TextImageHtmlHandler();
            SAXParserImpl.newInstance(null).parse((InputStream)new ByteArrayInputStream(html.getBytes("UTF-8")), (DefaultHandler)handler);
            return handler.getTextImage();
        }
        catch (SAXException e) {
            throw new HtmlParseException("Unable to parse the HTML, see the stacktrace for details.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new HtmlParseException("The encoding is not supported.", e);
        }
        catch (IOException e) {
            throw new HtmlParseException("Unable to create a TextImage from the HTML, see the stacktrace for details.", e);
        }
    }
}

