/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.capaxit.imagegenerator.builders;

import java.awt.image.BufferedImage;
import org.docx4j.org.capaxit.imagegenerator.Margin;
import org.docx4j.org.capaxit.imagegenerator.TextImage;
import org.docx4j.org.capaxit.imagegenerator.impl.TextImageImpl;

public final class WaterMarkImageBuilder {
    private final int width;
    private final int height;
    private final Margin margin;

    public WaterMarkImageBuilder(int width, int height, Margin margin) {
        if (margin == null) {
            throw new IllegalArgumentException("The margin may not be null.");
        }
        this.width = width;
        this.height = height;
        this.margin = margin;
    }

    public TextImage build(BufferedImage waterMark) {
        TextImageImpl image = new TextImageImpl(this.width, this.height);
        for (int x = 0; x < this.width; x += waterMark.getWidth()) {
            for (int y = 0; y < this.height; y += waterMark.getHeight()) {
                image.write(waterMark, x, y);
            }
        }
        image.setMargin(this.margin);
        return image;
    }
}

